/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.decorators;

import com.fold1.data.Symmetry;
import com.fold1.eulumdat.tools.decorators.AbstractEulumdatDecorator;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.properties.EulumdatProperty;
import com.fold1.eulumdat.tools.utils.Utils;
import java.net.URL;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class SymmetryDecorator
extends AbstractEulumdatDecorator {
    public static final String ID = "com.fold1.eulumdat.tools.decorators.SymmetryDecorator";
    private int quadrant;
    private static final String[] SYMMETRY_ICON_PATH = new String[]{"icons/sym_none.png", "icons/sym_rot.png", "icons/sym_0.png", "icons/sym_90.png", "icons/sym_quad.png"};
    private ImageDescriptor descriptor;

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IResource && ((IResource)element).exists() && Utils.isEulumdat((IResource)element)) {
            int index = -1;
            String symmetry = null;
            IResource res = (IResource)element;
            try {
                EulumdatProperty property = (EulumdatProperty)res.getSessionProperty(EulumdatProperty.EULUMDAT_PROPKEY);
                if (property == null) {
                    return;
                }
                symmetry = property.getSymmetry();
                index = Symmetry.symmetryFromString((String)symmetry);
                assert (index >= 0 && index < SYMMETRY_ICON_PATH.length);
                URL url = FileLocator.find((Bundle)Platform.getBundle((String)"com.fold1.eulumdat.tools"), (IPath)new Path(SYMMETRY_ICON_PATH[index]), null);
                if (url == null) {
                    return;
                }
                this.descriptor = ImageDescriptor.createFromURL((URL)url);
                this.quadrant = 1;
                decoration.addOverlay(this.descriptor, this.quadrant);
            }
            catch (ResourceException property) {
            }
            catch (Exception e) {
                Logger.logError("Unable to decorate with Symmetry : " + res.getName(), e);
            }
        }
    }

    public void dispose() {
    }

    public static SymmetryDecorator getSymmetryDecorator() {
        IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        return (SymmetryDecorator)decoratorManager.getBaseLabelProvider(ID);
    }
}

