/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.decorators;

import com.fold1.eulumdat.tools.EulumdatToolsActivator;
import com.fold1.eulumdat.tools.decorators.AbstractEulumdatDecorator;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.preferences.EulumdatToolsPreferences;
import com.fold1.eulumdat.tools.preferences.PreferenceChangeListener;
import com.fold1.eulumdat.tools.properties.EulumdatProperty;
import com.fold1.eulumdat.tools.utils.Utils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;

public class PropertyDecorator
extends AbstractEulumdatDecorator
implements PreferenceChangeListener {
    public static final String ID = "com.fold1.eulumdat.tools.decorators.PropertyDecorator";
    private boolean showDescription = true;
    private boolean showLamps = false;
    private boolean showSymmetry = false;
    private boolean showType = false;

    public PropertyDecorator() {
        EulumdatToolsPreferences.getInstance().addPreferenceChangeListener(this);
        this.readPreferences();
    }

    private void readPreferences() {
        IPreferenceStore store = EulumdatToolsActivator.getDefault().getPreferenceStore();
        String pref = store.getString("LabelDecorator");
        this.showDescription = "ShowName".equals(pref);
        this.showLamps = "ShowLamps".equals(pref);
        this.showSymmetry = "ShowSymmetry".equals(pref);
        this.showType = "ShowType".equals(pref);
        String s = "undefined";
        if (this.showDescription) {
            s = "Description";
        } else if (this.showLamps) {
            s = "Lamps";
        } else if (this.showSymmetry) {
            s = "Symmetry";
        } else if (this.showType) {
            s = "Type";
        }
        if (Platform.inDevelopmentMode()) {
            Logger.logInfo("Reading PropertyDecorator Preferences, setting to : " + s);
        }
    }

    private static boolean myPref(String pref) {
        return "LabelDecorator".equals(pref) || "ShowName".equals(pref) || "ShowLamps".equals(pref) || "ShowType".equals(pref) || "ShowSymmetry".equals(pref);
    }

    public void dispose() {
        EulumdatToolsPreferences.getInstance().removePreferenceChangeListener(this);
    }

    public void decorate(Object element, IDecoration decoration) {
        String newLabel = "";
        if (element instanceof IResource && ((IResource)element).exists() && Utils.isEulumdat((IResource)element)) {
            IFile file = (IFile)element;
            if (PropertyDecorator.getMaxSeverity(file) > 2) {
                return;
            }
            try {
                EulumdatProperty property = (EulumdatProperty)file.getSessionProperty(EulumdatProperty.EULUMDAT_PROPKEY);
                if (property == null) {
                    property = EulumdatProperty.createProperty(file);
                    file.setSessionProperty(EulumdatProperty.EULUMDAT_PROPKEY, (Object)property);
                    return;
                }
                newLabel = this.decorateLabel(newLabel, property);
            }
            catch (CoreException e) {
                Logger.logError("Unable to decorate with Properties", e);
            }
        }
        decoration.addSuffix(newLabel);
    }

    private String decorateLabel(String newLabel, EulumdatProperty property) {
        if (property != null) {
            String decoratedLabel = null;
            if (this.showDescription) {
                String description;
                if ("".equals(property.getId())) {
                    description = property.getProductname();
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(property.getId());
                    stringBuilder.append(" ");
                    stringBuilder.append(property.getProductname());
                    description = stringBuilder.toString();
                }
                decoratedLabel = PropertyDecorator.concat(newLabel, description);
            }
            if (this.showSymmetry) {
                decoratedLabel = PropertyDecorator.concat(newLabel, property.getSymmetry());
            }
            if (this.showType) {
                decoratedLabel = PropertyDecorator.concat(newLabel, property.getType());
            }
            if (this.showLamps) {
                int i = 0;
                while (i < property.getLampset().length) {
                    String lamp = property.getLampset()[i];
                    decoratedLabel = PropertyDecorator.concat(newLabel, lamp);
                    ++i;
                }
            }
            if (decoratedLabel != null) {
                return decoratedLabel;
            }
        }
        return newLabel;
    }

    private static String concat(String label, String tag) {
        if (label.endsWith("|")) {
            return label + tag + "|";
        }
        return label + " |" + tag + "|";
    }

    @Override
    public void preferenceChanged(String pref) {
        if (!PropertyDecorator.myPref(pref)) {
            return;
        }
        this.readPreferences();
        AbstractEulumdatDecorator.refresh(PropertyDecorator.getDecoratorInstance());
    }

    public static AbstractEulumdatDecorator getDecoratorInstance() {
        IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        return (AbstractEulumdatDecorator)decoratorManager.getBaseLabelProvider(ID);
    }
}

