/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.decorators;

import com.fold1.eulumdat.tools.decorators.AbstractEulumdatDecorator;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.properties.EulumdatProperty;
import com.fold1.eulumdat.tools.utils.Utils;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;

public class PhotometryTypeDecorator
extends AbstractEulumdatDecorator {
    public static final String ID = "com.fold1.eulumdat.tools.decorators.PhotometryTypeDecorator";

    public void decorate(Object element, IDecoration decoration) {
        String newLabel = "";
        if (element instanceof IResource && ((IResource)element).exists() && Utils.isEulumdat((IResource)element)) {
            IFile file = (IFile)element;
            if (PhotometryTypeDecorator.getMaxSeverity(file) > 2) {
                return;
            }
            try {
                EulumdatProperty property = (EulumdatProperty)file.getSessionProperty(EulumdatProperty.EULUMDAT_PROPKEY);
                if (property == null) {
                    property = EulumdatProperty.createProperty(file);
                    file.setSessionProperty(EulumdatProperty.EULUMDAT_PROPKEY, (Object)property);
                }
                newLabel = PhotometryTypeDecorator.decorateLabel(newLabel, property);
            }
            catch (ResourceException property) {
            }
            catch (CoreException e) {
                Logger.logError("Unable to decorate with Properties", e);
            }
        }
        decoration.addSuffix(newLabel);
    }

    private static String decorateLabel(String newLabel, EulumdatProperty property) {
        if (property != null && "absolute photometry".equals(property.getPhotometryType())) {
            return newLabel + " " + property.getPhotometryType();
        }
        return newLabel;
    }

    public void dispose() {
    }

    public static PhotometryTypeDecorator getPropertyDecorator() {
        IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        return (PhotometryTypeDecorator)decoratorManager.getBaseLabelProvider(ID);
    }
}

