/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.decorators;

import com.fold1.eulumdat.tools.decorators.AbstractEulumdatDecorator;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.properties.EulumdatProperty;
import com.fold1.eulumdat.tools.utils.Utils;
import java.net.URL;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class FluxDecorator
extends AbstractEulumdatDecorator {
    public static final String ID = "com.fold1.eulumdat.tools.decorators.FluxDecorator";
    private int quadrant;
    private static final String ICONPREFIX = "icons/";
    private static final String ICONSUFFIX = ".png";
    private ImageDescriptor descriptor;

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IResource && Utils.isEulumdat((IResource)element)) {
            String flux = null;
            IResource res = (IResource)element;
            try {
                EulumdatProperty property = (EulumdatProperty)res.getSessionProperty(EulumdatProperty.EULUMDAT_PROPKEY);
                if (property == null) {
                    return;
                }
                flux = property.getFluxDistribution();
                URL url = FileLocator.find((Bundle)Platform.getBundle((String)"com.fold1.eulumdat.tools"), (IPath)new Path(ICONPREFIX + flux + ICONSUFFIX), null);
                if (url == null) {
                    return;
                }
                this.descriptor = ImageDescriptor.createFromURL((URL)url);
                this.quadrant = 0;
                decoration.addOverlay(this.descriptor, this.quadrant);
            }
            catch (Exception e) {
                Logger.logError("Unable to decorate with Flux : " + res.getName(), e);
            }
        }
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        AbstractEulumdatDecorator fluxDecorator = FluxDecorator.getDecoratorInstance();
        if (fluxDecorator == null) {
            return false;
        }
        if (Platform.inDevelopmentMode()) {
            Logger.logInfo(element.toString() + " -- " + property);
        }
        return true;
    }

    public static AbstractEulumdatDecorator getDecoratorInstance() {
        IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        return (AbstractEulumdatDecorator)decoratorManager.getLabelDecorator(ID);
    }
}

