/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.decorators;

import com.fold1.eulumdat.tools.log.Logger;
import java.util.List;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractEulumdatDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String TOP_RIGHT = "TOP_RIGHT";
    public static final String TOP_LEFT = "TOP_LEFT";
    public static final String BOTTOM_RIGHT = "BOTTOM_RIGHT";
    public static final String BOTTOM_LEFT = "BOTTOM_LEFT";
    public static final String UNDERLAY = "UNDERLAY";
    public static final int EULUMDAT_ERROR = 3;
    public static final int EULUMDAT_WARNING = 2;
    public static final int EULUMDAT_INFO = 1;
    public static final int EULUMDAT_OK = 0;

    public static AbstractEulumdatDecorator getDecoratorInstance() {
        return null;
    }

    protected void fireLabelEvent(LabelProviderChangedEvent event) {
        Display.getDefault().asyncExec(() -> this.fireLabelProviderChanged(event));
    }

    public static int getMaxSeverity(IFile file) {
        int maxSeverity = 0;
        try {
            IMarker[] markers;
            if (!file.exists() || !file.getProject().isAccessible()) {
                return maxSeverity;
            }
            IMarker[] iMarkerArray = markers = file.findMarkers("com.fold1.eulumdat.tools.validator.eulumdatProblem", true, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (AbstractEulumdatDecorator.isError(marker)) {
                    maxSeverity = 3;
                    break;
                }
                if (AbstractEulumdatDecorator.isWarning(marker)) {
                    maxSeverity = 2;
                } else if (AbstractEulumdatDecorator.isInfo(marker)) {
                    maxSeverity = 1;
                }
                ++n2;
            }
        }
        catch (ResourceException marker) {
        }
        catch (CoreException e) {
            Logger.logError("Unable to decorate with Problems", e);
        }
        return maxSeverity;
    }

    private static boolean isInfo(IMarker marker) throws CoreException {
        Object attribute = marker.getAttribute("severity");
        if (attribute instanceof Integer) {
            Integer severity = (Integer)attribute;
            return severity == 0;
        }
        return false;
    }

    private static boolean isWarning(IMarker marker) throws CoreException {
        Object attribute = marker.getAttribute("severity");
        if (attribute instanceof Integer) {
            Integer severity = (Integer)attribute;
            return severity == 1;
        }
        return false;
    }

    private static boolean isError(IMarker marker) throws CoreException {
        Object attribute = marker.getAttribute("severity");
        if (attribute instanceof Integer) {
            Integer severity = (Integer)attribute;
            return severity == 2;
        }
        return false;
    }

    public static void refresh(AbstractEulumdatDecorator decoratorInstance, List<IResource> resourcesToBeUpdated) {
        if (decoratorInstance == null) {
            return;
        }
        decoratorInstance.fireLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)decoratorInstance, resourcesToBeUpdated.toArray()));
    }

    public static void refresh(AbstractEulumdatDecorator decoratorInstance, IResource resourceToBeUpdated) {
        if (decoratorInstance == null) {
            return;
        }
        decoratorInstance.fireLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)decoratorInstance, (Object)resourceToBeUpdated));
    }

    public static void refresh(AbstractEulumdatDecorator decoratorInstance) {
        if (decoratorInstance == null) {
            return;
        }
        decoratorInstance.fireLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)decoratorInstance));
    }
}

