/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools;

import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.utils.BuilderUtils;
import com.fold1.eulumdat.tools.utils.Rebuilder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

public class ProjectStateVisitor
implements IResourceDeltaVisitor {
    private String nature;

    public ProjectStateVisitor(String natureId) {
        this.nature = natureId;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IProject project;
        if (delta != null && delta.getResource() instanceof IProject && (project = (IProject)delta.getResource()).isAccessible() && project.hasNature(this.nature)) {
            switch (delta.getKind()) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    if ((delta.getFlags() & 0x4000) == 0) break;
                    Logger.logInfo("ProjectStateManager opens : " + project.getName());
                    String builder = BuilderUtils.findBuilder(this.nature);
                    Rebuilder rebuilder = new Rebuilder("Open Project rebuild", this.nature, builder, project);
                    rebuilder.schedule(50L);
                    break;
                }
                default: {
                    Logger.logInfo("Change event [" + delta.getKind() + "] for " + project.getName());
                }
            }
            return false;
        }
        return true;
    }
}

