/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools;

import com.fold1.eulumdat.tools.ProjectStateVisitor;
import com.fold1.eulumdat.tools.log.Logger;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

@ThreadSafe
public final class ProjectStateManager
implements IResourceChangeListener {
    private static ProjectStateManager instance;
    private final Set<String> natures;

    private ProjectStateManager() {
        instance = this;
        this.natures = new HashSet<String>();
        this.natures.add("com.fold1.eulumdat.tools.validator.eulumdatValidatorProjectNature");
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProjectStateManager getInstance() {
        ProjectStateManager r = instance;
        if (r != null) return instance;
        Class<ProjectStateManager> clazz = ProjectStateManager.class;
        synchronized (ProjectStateManager.class) {
            r = instance;
            if (r != null) return instance;
            instance = r = new ProjectStateManager();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void addNature(String nature) {
        this.natures.add(nature);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResource resource;
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            for (String natureId : this.natures) {
                if (ProjectStateManager.visitResource(delta, natureId)) continue;
            }
        }
        if ((resource = event.getResource()) instanceof IProject) {
            IProject project = (IProject)resource;
            Logger.logInfo("ProjectStateManager closes : " + project.getName());
            for (String natureId : this.natures) {
                if (!project.isAccessible()) continue;
                try {
                    if (project.hasNature(natureId)) continue;
                }
                catch (CoreException e) {
                    Logger.logError("Problem in project close : " + e.getMessage(), e);
                }
            }
        }
    }

    private static boolean visitResource(IResourceDelta delta, String natureId) {
        ProjectStateVisitor projectStateChangedVisitor = new ProjectStateVisitor(natureId);
        try {
            delta.accept((IResourceDeltaVisitor)projectStateChangedVisitor);
        }
        catch (CoreException e) {
            Logger.logError("Problem in project state change : " + e.getMessage(), e);
            return false;
        }
        return true;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        instance = null;
    }
}

