/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools;

import com.bdaum.overlaypages.OverlayUtils;
import com.fold1.eulumdat.tools.ProjectStateManager;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.preferences.EulumdatToolsPreferences;
import com.fold1.eulumdat.tools.preferences.RegistrationController;
import com.fold1.eulumdat.tools.properties.EulumdatFileAdapterFactory;
import com.fold1.eulumdat.tools.utils.BuilderUtils;
import com.fold1.eulumdat.tools.utils.Rebuilder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EulumdatToolsActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.fold1.eulumdat.tools";
    private static final String ICONPATH = "icons/eulumdat.png";
    public static final String COLLAPSE_ALL = "icons/collapseall.png";
    public static final String EXPAND_ALL = "icons/expandall.png";
    public static final String TYPE_TOGGLE = "icons/type.png";
    public static final String LAMP_TOGGLE = "icons/lamps.png";
    public static final String SYM_TOGGLE = "icons/symmetry.png";
    private EulumdatFileAdapterFactory factory;
    private static EulumdatToolsActivator plugin;
    private static ProjectStateManager manager;
    private static Image eulumdatIcon;

    public EulumdatToolsActivator() {
        plugin = this;
        Logger.initialize(plugin, PLUGIN_ID);
        manager = ProjectStateManager.getInstance();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.factory = new EulumdatFileAdapterFactory();
        IAdapterManager mgr = Platform.getAdapterManager();
        mgr.registerAdapters((IAdapterFactory)this.factory, IResource.class);
        OverlayUtils.initialize(plugin);
        EulumdatToolsPreferences.createInstance(this.getBundle(), this.getPreferenceStore());
        RegistrationController.phoneHome();
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                Job.getJobManager().cancel((Object)EulumdatToolsActivator.PLUGIN_ID);
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        });
        PlatformUI.getWorkbench().getProgressService().registerIconForFamily(EulumdatToolsActivator.getImageDescriptor(ICONPATH), (Object)PLUGIN_ID);
    }

    public static Image getEulumdatIcon() {
        if (eulumdatIcon == null) {
            eulumdatIcon = EulumdatToolsActivator.getImageDescriptor(ICONPATH).createImage();
        }
        return eulumdatIcon;
    }

    public static EulumdatToolsActivator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return ResourceLocator.imageDescriptorFromBundle((String)PLUGIN_ID, (String)path).orElse(null);
    }

    public void stop(BundleContext context) throws Exception {
        Job.getJobManager().cancel((Object)PLUGIN_ID);
        Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)this.factory);
        if (eulumdatIcon != null) {
            eulumdatIcon.dispose();
        }
        manager.dispose();
        plugin = null;
        super.stop(context);
    }

    public static void refreshLabels() {
        try {
            String builder = BuilderUtils.findBuilder("com.fold1.eulumdat.tools.validator.eulumdatValidatorProjectNature");
            Rebuilder rebuilder = new Rebuilder("Initializing Eulumdat Tools", "com.fold1.eulumdat.tools.validator.eulumdatValidatorProjectNature", builder);
            rebuilder.schedule(20L);
        }
        catch (CoreException e) {
            Logger.logError("Error refreshing labels", e);
        }
    }
}

