/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.chart;

import com.fold1.chart.AbstractPainter;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class GraphingStrategyCanvas
extends Canvas {
    private static final long serialVersionUID = -8677273779488700189L;
    private AbstractPainter painter;

    public GraphingStrategyCanvas() {
        this.setPainter(new DefaultPainter());
    }

    public void setPainter(AbstractPainter painter) {
        if (painter == null) {
            throw new IllegalArgumentException("Cannot use null painter");
        }
        this.painter = painter;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.painter != null) {
            this.painter.paint(g2d, this.getWidth(), this.getHeight());
        }
    }

    private static final class DefaultPainter
    extends AbstractPainter {
        private DefaultPainter() {
        }

        @Override
        public void paint(Graphics2D g2d, int width, int height) {
            g2d.setStroke(new BasicStroke(4.0f));
            g2d.setPaint(Color.PINK);
            Rectangle r = new Rectangle(width, height);
            r.grow(-10, -10);
            g2d.drawRect(r.x, r.y, r.width, r.height);
        }
    }
}

