/*
 * Decompiled with CFR 0.152.
 */
package com.bdaum.overlaypages;

import com.bdaum.overlaypages.PropertyStore;
import com.fold1.eulumdat.tools.log.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class OverlayUtils {
    private static AbstractUIPlugin bundle = null;

    private OverlayUtils() {
    }

    public static void initialize(AbstractUIPlugin b) {
        bundle = b;
    }

    public static String getOverlayedPreferenceValue(IPreferenceStore store, IResource resource, String pageId, String key) {
        IProject project = resource.getProject();
        String value = null;
        if (OverlayUtils.useProjectSettings((IResource)project, pageId)) {
            value = OverlayUtils.getProperty(resource, pageId, key);
        }
        if (value != null) {
            return value;
        }
        return store.getString(key);
    }

    private static boolean useProjectSettings(IResource resource, String pageId) {
        String use = OverlayUtils.getProperty(resource, pageId, "useProjectSettings");
        return "true".equals(use);
    }

    public static IPreferenceStore getStoreToUse(IResource p, String pageID) {
        IPreferenceStore workspaceStore = null;
        if (bundle == null) {
            Logger.logError("OverlayUtils not initialized with bundle", new IllegalStateException("Bunlde not initialized"));
        } else {
            workspaceStore = bundle.getPreferenceStore();
        }
        Object store = workspaceStore;
        if (p != null && OverlayUtils.useProjectSettings(p, pageID)) {
            store = new PropertyStore((IResource)p.getProject(), workspaceStore, pageID);
            Logger.logInfo("Using Project Preferences for : " + p.getProject().getName() + ", page :" + pageID);
        } else if (p != null) {
            Logger.logInfo("Using Workspace Preferences for : " + p.getProject().getName() + ", page :" + pageID);
        }
        return store;
    }

    private static String getProperty(IResource resource, String pageId, String key) {
        try {
            return resource.getPersistentProperty(new QualifiedName(pageId, key));
        }
        catch (CoreException e) {
            Logger.logError("Failure to get Persistent Property in OverlayUtils", e);
            return null;
        }
    }
}

