/*
 * Decompiled with CFR 0.152.
 */
package com.bdaum.overlaypages;

import com.bdaum.overlaypages.Messages;
import com.bdaum.overlaypages.PropertyStore;
import com.fold1.eulumdat.tools.log.Logger;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.part.PageBook;

public abstract class OverlayPage
extends PropertyPage {
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    public static final String USEPROJECTSETTINGS = "useProjectSettings";
    private Composite contents;
    private ImageDescriptor image;
    private PropertyStore overlayStore;
    private String pageId;
    private Button useWorkspaceSettingsButton;
    private Button useProjectSettingsButton;
    private Button configureButton;

    public OverlayPage() {
    }

    public OverlayPage(String title) {
        this.setTitle(title);
    }

    public OverlayPage(String title, ImageDescriptor image) {
        this.setTitle(title);
        this.setImageDescriptor(image);
        this.image = image;
    }

    protected void configureWorkspaceSettings() {
        try {
            IPreferencePage page = (IPreferencePage)((Object)((Object)this)).getClass().getDeclaredConstructor(new Class[]{null}).newInstance(new Object[0]);
            page.setTitle(this.getTitle());
            page.setImageDescriptor(this.image);
            this.showPreferencePage(this.pageId, page);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Logger.logError("Cannot configure Workspace Settings in " + ((Object)((Object)this)).getClass().getName(), e);
        }
    }

    protected Control createContents(Composite parent) {
        if (this.isPropertyPage()) {
            this.createSelectionGroup(parent);
        }
        this.contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.contents.setLayout((Layout)layout);
        this.contents.setLayoutData((Object)new GridData(768));
        return this.contents;
    }

    public void createControl(Composite parent) {
        if (this.isPropertyPage()) {
            this.pageId = this.getPageId();
            this.overlayStore = new PropertyStore((IResource)this.getElement(), super.getPreferenceStore(), this.pageId);
        }
        super.createControl(parent);
        if (this.isPropertyPage()) {
            this.setControlsEnabled();
        }
    }

    private Button createRadioButton(Composite parent, String label) {
        final Button button = new Button(parent, 16);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverlayPage.this.configureButton.setEnabled(OverlayPage.this.useWorkspaceSettingsButton.equals(button));
                OverlayPage.this.setControlsEnabled();
            }
        });
        return button;
    }

    private void createSelectionGroup(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        Composite radioGroup = new Composite(comp, 0);
        radioGroup.setLayout((Layout)new GridLayout());
        radioGroup.setLayoutData((Object)new GridData(768));
        this.useWorkspaceSettingsButton = this.createRadioButton(radioGroup, Messages.getString("OverlayPage.Use_Workspace_Settings"));
        this.useProjectSettingsButton = this.createRadioButton(radioGroup, Messages.getString("OverlayPage.Use_Project_Settings"));
        this.configureButton = new Button(comp, 8);
        this.configureButton.setText(Messages.getString("OverlayPage.Configure_Workspace_Settings"));
        this.configureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverlayPage.this.configureWorkspaceSettings();
            }
        });
        try {
            String use = ((IResource)this.getElement()).getPersistentProperty(new QualifiedName(this.pageId, USEPROJECTSETTINGS));
            if (TRUE.equals(use)) {
                this.useProjectSettingsButton.setSelection(true);
                this.configureButton.setEnabled(false);
            } else {
                this.useWorkspaceSettingsButton.setSelection(true);
            }
        }
        catch (CoreException e) {
            this.useWorkspaceSettingsButton.setSelection(true);
        }
    }

    protected abstract String getPageId();

    public IPreferenceStore getPreferenceStore() {
        if (this.isPropertyPage()) {
            return this.overlayStore;
        }
        return super.getPreferenceStore();
    }

    public boolean isPropertyPage() {
        return this.getElement() != null;
    }

    protected void performDefaults() {
        if (this.isPropertyPage()) {
            this.useWorkspaceSettingsButton.setSelection(true);
            this.useProjectSettingsButton.setSelection(false);
            this.configureButton.setEnabled(true);
            this.setControlsEnabled();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result && this.isPropertyPage()) {
            IResource resource = (IResource)this.getElement();
            try {
                String value = this.useProjectSettingsButton.getSelection() ? TRUE : FALSE;
                resource.setPersistentProperty(new QualifiedName(this.pageId, USEPROJECTSETTINGS), value);
            }
            catch (CoreException e) {
                Logger.logError("Cannot set Persistent Property in " + ((Object)((Object)this)).getClass().getName(), e);
            }
        }
        return result;
    }

    private void setControlsEnabled() {
        boolean enabled = this.useProjectSettingsButton.getSelection();
        this.setControlsEnabled(enabled);
    }

    protected void setControlsEnabled(boolean enabled) {
        this.setControlsEnabled(this.contents, enabled);
    }

    private void setControlsEnabled(Composite root, boolean enabled) {
        Control[] children;
        Control[] controlArray = children = root.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control element2 = controlArray[n2];
            Control child = element2;
            if (!(child instanceof CTabFolder || child instanceof TabFolder || child instanceof PageBook)) {
                child.setEnabled(enabled);
            }
            if (child instanceof Composite) {
                this.setControlsEnabled((Composite)child, enabled);
            }
            ++n2;
        }
    }

    protected void showPreferencePage(String id, IPreferencePage page) {
        PreferenceNode targetNode = new PreferenceNode(id, page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        PreferenceDialog dialog = new PreferenceDialog(this.getControl().getShell(), manager);
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), () -> OverlayPage.lambda$0(dialog, (IPreferenceNode)targetNode));
    }

    private static /* synthetic */ void lambda$0(PreferenceDialog preferenceDialog, IPreferenceNode iPreferenceNode) {
        preferenceDialog.create();
        preferenceDialog.setMessage(iPreferenceNode.getLabelText());
        preferenceDialog.open();
    }
}

