/*
 * Decompiled with CFR 0.152.
 */
package com.bdaum.overlaypages;

import com.bdaum.overlaypages.Messages;
import com.bdaum.overlaypages.PropertyStore;
import com.fold1.eulumdat.tools.log.Logger;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbenchPropertyPage;

public abstract class FieldEditorOverlayPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage {
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    public static final String USEPROJECTSETTINGS = "useProjectSettings";
    private Link configureButton;
    private final List<FieldEditor> editors = new ArrayList<FieldEditor>();
    private IAdaptable element;
    private ImageDescriptor image;
    private IPreferenceStore overlayStore;
    private String pageId;
    private Button useProjectSettingsButton;

    public FieldEditorOverlayPage(int style) {
        super(style);
    }

    public FieldEditorOverlayPage(String title, ImageDescriptor image, int style) {
        super(title, image, style);
        this.image = image;
    }

    public FieldEditorOverlayPage(String title, int style) {
        super(title, style);
    }

    protected void addField(FieldEditor editor) {
        this.editors.add(editor);
        super.addField(editor);
    }

    protected void configureWorkspaceSettings() {
        try {
            IPreferencePage page = (IPreferencePage)((Object)((Object)this)).getClass().getDeclaredConstructor(new Class[]{null}).newInstance(new Object[0]);
            page.setTitle(this.getTitle());
            page.setImageDescriptor(this.image);
            this.showPreferencePage(this.pageId, page);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Logger.logError("Problem creating new preference page: ", e);
        }
    }

    private Button createCheckboxButton(Composite parent, String label) {
        final Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldEditorOverlayPage.this.configureButton.setEnabled(!button.getSelection());
                FieldEditorOverlayPage.this.updateFieldEditors();
            }
        });
        return button;
    }

    protected Control createContents(Composite parent) {
        if (this.isPropertyPage()) {
            this.createSelectionGroup(parent);
        }
        return super.createContents(parent);
    }

    public void createControl(Composite parent) {
        if (this.isPropertyPage()) {
            this.pageId = this.getPageId();
            this.overlayStore = new PropertyStore((IResource)this.getElement(), super.getPreferenceStore(), this.pageId);
        }
        super.createControl(parent);
        if (this.isPropertyPage()) {
            this.updateFieldEditors();
        }
    }

    private void createSelectionGroup(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.useProjectSettingsButton = this.createCheckboxButton(comp, Messages.getString("OverlayPage.Use_Project_Settings"));
        this.configureButton = new Link(comp, 8);
        this.configureButton.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.configureButton.setText(Messages.getString("OverlayPage.Configure_Workspace_Settings"));
        this.configureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldEditorOverlayPage.this.configureWorkspaceSettings();
            }
        });
        try {
            String use = ((IResource)this.getElement()).getPersistentProperty(new QualifiedName(this.pageId, USEPROJECTSETTINGS));
            if (TRUE.equals(use)) {
                this.useProjectSettingsButton.setSelection(true);
                this.configureButton.setEnabled(false);
            } else {
                this.useProjectSettingsButton.setSelection(false);
                this.configureButton.setEnabled(true);
            }
        }
        catch (CoreException e) {
            Logger.logError("Problem with creating Preferences page", e);
        }
        Label line = new Label(comp, 0x1000122);
        line.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
    }

    public IAdaptable getElement() {
        return this.element;
    }

    protected abstract String getPageId();

    public IPreferenceStore getPreferenceStore() {
        if (this.isPropertyPage()) {
            return this.overlayStore;
        }
        return super.getPreferenceStore();
    }

    public boolean isPropertyPage() {
        return this.getElement() != null;
    }

    protected void performDefaults() {
        if (this.isPropertyPage()) {
            this.useProjectSettingsButton.setSelection(false);
            this.configureButton.setEnabled(true);
            this.updateFieldEditors();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result && this.isPropertyPage()) {
            IResource resource = (IResource)this.getElement();
            try {
                String value = this.useProjectSettingsButton.getSelection() ? TRUE : FALSE;
                resource.setPersistentProperty(new QualifiedName(this.pageId, USEPROJECTSETTINGS), value);
            }
            catch (CoreException e) {
                Logger.logError("Cannot set PersistentProperty in " + ((Object)((Object)this)).getClass().getName(), e);
            }
        }
        return result;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    protected void showPreferencePage(String id, IPreferencePage page) {
        PreferenceNode targetNode = new PreferenceNode(id, page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        PreferenceDialog dialog = new PreferenceDialog(this.getControl().getShell(), manager);
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), () -> FieldEditorOverlayPage.lambda$0(dialog, (IPreferenceNode)targetNode));
    }

    private void updateFieldEditors() {
        boolean enabled = this.useProjectSettingsButton.getSelection();
        this.updateFieldEditors(enabled);
        this.updateFieldEditorsHook(enabled);
    }

    protected void updateFieldEditors(boolean enabled) {
        Composite parent = this.getFieldEditorParent();
        for (FieldEditor editor : this.editors) {
            editor.setEnabled(enabled, parent);
        }
    }

    public void updateFieldEditorsHook(boolean enabled) {
    }

    private static /* synthetic */ void lambda$0(PreferenceDialog preferenceDialog, IPreferenceNode iPreferenceNode) {
        preferenceDialog.create();
        preferenceDialog.setMessage(iPreferenceNode.getLabelText());
        preferenceDialog.open();
    }
}

