/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.handler;

import com.fold1.eulumdat.blog.Logger;
import com.fold1.eulumdat.blog.reader.BlogEntry;
import com.fold1.eulumdat.blog.reader.EulumdatBlogReader;
import com.fold1.eulumdat.blog.reader.SplashEditorInput;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class OpenSplash
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        block6: {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            long startTime = System.nanoTime();
            try {
                List<BlogEntry> entries = EulumdatBlogReader.getInstance().getEntries2().get();
                page.openEditor((IEditorInput)new SplashEditorInput(entries), "com.fold1.eulumdat.blog.editors.EulumdatSplashEditor");
            }
            catch (CoreException e) {
                Logger.logError("Cannot Open Splash Editor", e);
                Logger.logInfo(String.format("Open splash Editor takes %d ms", (System.nanoTime() - startTime) / 1000000L));
                break block6;
            }
            catch (Throwable e) {
                try {
                    IStatus status = Logger.createStatus(4, 1, "Error in Splash startup", e);
                    Logger.log(status);
                }
                catch (Throwable throwable) {
                    Logger.logInfo(String.format("Open splash Editor takes %d ms", (System.nanoTime() - startTime) / 1000000L));
                    throw throwable;
                }
                Logger.logInfo(String.format("Open splash Editor takes %d ms", (System.nanoTime() - startTime) / 1000000L));
                break block6;
            }
            Logger.logInfo(String.format("Open splash Editor takes %d ms", (System.nanoTime() - startTime) / 1000000L));
        }
        return null;
    }
}

