/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.blog.startup;

import com.fold1.eulumdat.blog.Logger;
import com.fold1.eulumdat.blog.reader.BlogEntry;
import com.fold1.eulumdat.blog.reader.EulumdatBlogReader;
import com.fold1.eulumdat.blog.reader.SplashEditorInput;
import com.fold1.eulumdat.tools.preferences.RegistrationController;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class Startup
implements IStartup {
    public void earlyStartup() {
        UIJob splashJob = new UIJob("EulmdatTools Splash"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                block7: {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    long startTime = System.nanoTime();
                    try {
                        if (Platform.inDebugMode() || !RegistrationController.isValidFullLicense((boolean)false)) {
                            List<BlogEntry> entries = EulumdatBlogReader.getInstance().getEntries2().get();
                            page.openEditor((IEditorInput)new SplashEditorInput(entries), "com.fold1.eulumdat.blog.editors.EulumdatSplashEditor");
                        }
                    }
                    catch (CoreException e) {
                        Logger.logError("Cannot Open Splash Editor", e);
                        Logger.logInfo(String.format("Open splash Editor takes %d ms", (System.nanoTime() - startTime) / 1000000L));
                        break block7;
                    }
                    catch (Throwable e) {
                        try {
                            IStatus status = Logger.createStatus(4, 1, "Error in Splash startup", e);
                            Logger.log(status);
                        }
                        catch (Throwable throwable) {
                            Logger.logInfo(String.format("Open splash Editor takes %d ms", (System.nanoTime() - startTime) / 1000000L));
                            throw throwable;
                        }
                        Logger.logInfo(String.format("Open splash Editor takes %d ms", (System.nanoTime() - startTime) / 1000000L));
                        break block7;
                    }
                    Logger.logInfo(String.format("Open splash Editor takes %d ms", (System.nanoTime() - startTime) / 1000000L));
                }
                return Status.OK_STATUS;
            }
        };
        splashJob.schedule(300L);
    }
}

