/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.blog.reader;

import com.fold1.eulumdat.blog.Logger;
import com.fold1.eulumdat.blog.reader.BlogEntry;
import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;

public final class EulumdatBlogReader {
    public static final String EULUMDAT_BLOGSPOT_COM = "https://eulumdat.blogspot.com/";
    private static final String EULUMDAT_BLOGSPOT_COM_RSS = "http://feeds.feedburner.com/EulumdatTools";
    private URL url;
    private static EulumdatBlogReader instance;

    private EulumdatBlogReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EulumdatBlogReader getInstance() throws CoreException {
        EulumdatBlogReader r = instance;
        if (r != null) return instance;
        Class<EulumdatBlogReader> clazz = EulumdatBlogReader.class;
        synchronized (EulumdatBlogReader.class) {
            r = instance;
            if (r != null) return instance;
            instance = r = new EulumdatBlogReader();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private static BlogEntry feedToEntry(SyndEntry entry) {
        return new BlogEntry(entry.getTitle(), entry.getLink(), ((SyndContent)entry.getContents().get(0)).getValue(), entry.getPublishedDate().getTime());
    }

    private static List<BlogEntry> getEntry(SyndFeed feed) {
        return feed.getEntries().stream().map(EulumdatBlogReader::feedToEntry).collect(Collectors.toList());
    }

    private static SyndFeed bodyToFeed(InputStream body) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (XmlReader reader = new XmlReader(body);){
                return new SyndFeedInput().build((Reader)reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FeedException | IOException e) {
            throw new CompletionException(e);
        }
    }

    public CompletableFuture<List<BlogEntry>> getEntries2() {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(EULUMDAT_BLOGSPOT_COM_RSS)).build();
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofInputStream()).thenApply(HttpResponse::body)).thenApply(EulumdatBlogReader::bodyToFeed)).thenApply(EulumdatBlogReader::getEntry)).orTimeout(20L, TimeUnit.SECONDS).exceptionally(t -> {
            Logger.logError(String.format("Could not fetch feed from '%s'", EULUMDAT_BLOGSPOT_COM_RSS), t);
            return Collections.emptyList();
        });
    }
}

