/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.blog.editors;

import com.fold1.eulumdat.blog.Logger;
import com.fold1.eulumdat.blog.editors.EulumdatSplashEditor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wb.swt.SWTResourceManager;

public class EulumdatOnYoutubeEditor
extends EditorPart
implements IPersistableEditor {
    public static final String ID = "com.fold1.eulumdat.blog.editors.EulumdatYoutubeEditor";
    protected static final String EULUMDAT_YOUTUBE = "youtube.com";
    private Browser browser;
    private IMemento savedMemento;
    private EulumdatSplashEditor eulumdatSplashEditor;

    public EulumdatOnYoutubeEditor(EulumdatSplashEditor eulumdatSplashEditor) {
        this.eulumdatSplashEditor = eulumdatSplashEditor;
    }

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setPartName("EulumdatTools on Youtube");
        container.setBackground(SWTResourceManager.getColor(3));
        GridLayout gl_container = new GridLayout(1, false);
        gl_container.horizontalSpacing = 10;
        gl_container.verticalSpacing = 10;
        gl_container.marginWidth = 10;
        gl_container.marginHeight = 10;
        container.setLayout((Layout)gl_container);
        this.browser = new Browser(container, 262144);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.browser.setSize(297, 471);
        this.browser.setUrl("https://www.youtube.com/playlist?list=PL7EAC97A77C8D8AAC");
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                if (event.location.contains("googleads.g.doubleclick.net/") || event.location.contains("accounts.google.com/ServiceLogin") || event.location.contains("sharethis.com") || event.location.contains("www.blogger.com/navbar.g") || event.location.contains("about:")) {
                    Logger.logInfo("YT IGNORING " + event.location);
                    event.doit = false;
                    return;
                }
                if (!(event.location.contains(EulumdatOnYoutubeEditor.EULUMDAT_YOUTUBE) || event.location.contains("consent.google.com/") || event.location.contains("consent.youtube.com/") || event.location.contains("www.youtube.com/embed"))) {
                    boolean result;
                    Logger.logInfo("YT REDIRECTING" + event.location);
                    event.doit = false;
                    if (!event.location.contains("google") && !(result = Program.launch((String)event.location))) {
                        Logger.logError("Failed to launch external browser for " + event.location, null);
                    }
                }
            }
        });
        this.browser.addAuthenticationListener(event -> {
            boolean bl = event.doit = false;
        });
        this.restoreFromMemento(this.savedMemento);
    }

    public void setFocus() {
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            if (Platform.inDevelopmentMode()) {
                Logger.logInfo("Outline Page requested for " + ((Object)((Object)this)).getClass().getName());
            }
            return null;
        }
        return super.getAdapter(adapter);
    }

    public void saveState(IMemento memento) {
        if (memento == null) {
            return;
        }
        String id = this.getSite().getId();
        Assert.isNotNull((Object)id);
        IMemento child = memento.createChild(id);
        if (child == null) {
            return;
        }
        child.putString("url", this.browser.getUrl());
    }

    public void restoreState(IMemento memento) {
        this.savedMemento = memento;
    }

    public void restoreFromMemento(IMemento memento) {
        if (memento == null) {
            return;
        }
        String id = this.getSite().getId();
        IMemento child = memento.getChild(id);
        if (child == null) {
            return;
        }
        String url = child.getString("url");
        if (url != null && url.trim().startsWith("http")) {
            this.browser.setUrl(url);
        }
    }
}

