/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.blog.editors;

import com.fold1.eulumdat.blog.Logger;
import com.fold1.eulumdat.blog.editors.BlogContentProvider;
import com.fold1.eulumdat.blog.editors.BlogLabelProvider;
import com.fold1.eulumdat.blog.editors.BlogOutlinePage;
import com.fold1.eulumdat.blog.editors.EulumdatSplashEditor;
import com.fold1.eulumdat.blog.reader.BlogEntry;
import com.fold1.eulumdat.blog.reader.SplashEditorInput;
import com.fold1.eulumdat.tools.preferences.RegistrationController;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wb.swt.SWTResourceManager;

public class EulumdatBlogEditor
extends EditorPart
implements IPersistableEditor {
    private static final int[] HIDDEN;
    private static final int[] VISIBLE;
    public static final String ID = "com.fold1.eulumdat.blog.editors.EulumdatBlogEditor";
    protected static final String EULUMDAT_BLOG = "eulumdat.blog";
    private Table table;
    private Browser browser;
    private TableViewer tableViewer;
    private Object outlinePage;
    private Composite viewerComposite;
    private IMemento savedMemento;
    private EulumdatSplashEditor eulumdatSplashEditor;

    static {
        int[] nArray = new int[2];
        nArray[0] = 5;
        HIDDEN = nArray;
        VISIBLE = new int[]{5, 1};
    }

    public EulumdatBlogEditor(EulumdatSplashEditor eulumdatSplashEditor) {
        this.eulumdatSplashEditor = eulumdatSplashEditor;
    }

    public void createPartControl(Composite parent) {
        final Composite container = new Composite(parent, 0);
        this.setPartName("eulumdat.blogger.com");
        container.setBackground(SWTResourceManager.getColor(14));
        GridLayout gl_container = new GridLayout(1, false);
        gl_container.horizontalSpacing = 10;
        gl_container.verticalSpacing = 10;
        gl_container.marginWidth = 10;
        gl_container.marginHeight = 10;
        container.setLayout((Layout)gl_container);
        Composite buttons = new Composite(container, 0);
        buttons.setBackground(SWTResourceManager.getColor(14));
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        Button openInBrowser = new Button(buttons, 0);
        openInBrowser.setText("Open in External Browser");
        openInBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)EulumdatBlogEditor.this.browser.getUrl());
            }
        });
        final Button btnCheckButton = new Button(buttons, 32);
        btnCheckButton.setForeground(SWTResourceManager.getColor(1));
        btnCheckButton.setText("Show Posts");
        btnCheckButton.setSelection(true);
        final SashForm sashForm = new SashForm(container, 68096);
        sashForm.setSashWidth(3);
        sashForm.setBackground(SWTResourceManager.getColor(14));
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        System.setProperty("httpclient.useragent", RegistrationController.getUserAgent());
        this.browser = new Browser((Composite)sashForm, 264192);
        this.viewerComposite = new Composite((Composite)sashForm, 2048);
        TableColumnLayout tcl_composite = new TableColumnLayout();
        this.viewerComposite.setLayout((Layout)tcl_composite);
        this.tableViewer = new TableViewer(this.viewerComposite, 67588);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnTitle = tableViewerColumn.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnTitle, (ColumnLayoutData)new ColumnWeightData(5, 200, true));
        tblclmnTitle.setText("Blog Post Title");
        TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn = tableViewerColumn_1.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnNewColumn, (ColumnLayoutData)new ColumnWeightData(1, 200, true));
        tblclmnNewColumn.setText("Published");
        this.tableViewer.setContentProvider((IContentProvider)new BlogContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new BlogLabelProvider());
        this.tableViewer.addSelectionChangedListener(event -> this.selectionChanged(event));
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.tableViewer.setInput(((SplashEditorInput)this.getEditorInput()).getEntries());
        this.browser.setUrl("https://eulumdat.blogspot.com/");
        sashForm.setWeights(VISIBLE);
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                if (event.location.contains("http://eulumdat.blog")) {
                    EulumdatBlogEditor.this.browser.setUrl(event.location.replaceFirst("http://", "https://"));
                    event.doit = false;
                    return;
                }
                this.showFiltering(event);
                if (event.location.contains("/googleads.g.doubleclick.net/") || event.location.contains("sharethis.com") || event.location.contains("www.blogger.com/navbar.g") || event.location.contains("about:")) {
                    event.doit = false;
                    return;
                }
                this.redirectNonBlogUrls(event);
            }

            private void redirectNonBlogUrls(LocationEvent event) {
                if (!(event.location.contains(EulumdatBlogEditor.EULUMDAT_BLOG) || event.location.contains("consent.google.com/") || event.location.contains("www.youtube.com/embed") || event.location.contains("www.blogger.com/") || event.location.contains("tpc.googlesyndication.com/") || event.location.contains("platform.twitter.com/widgets") || event.location.contains("feedproxy.google.com/~r/EulumdatTools/~3"))) {
                    boolean result;
                    event.doit = false;
                    if (Platform.inDevelopmentMode()) {
                        System.out.println("BL BLOCKING  : " + event.location);
                    }
                    if (!event.location.contains("google") && !(result = Program.launch((String)event.location))) {
                        Logger.logError("Failed to launch external browser for " + event.location, null);
                    }
                }
            }

            private void showFiltering(LocationEvent event) {
                if (Platform.inDevelopmentMode()) {
                    System.out.println("BL FILTERING : " + event.location);
                }
            }
        });
        this.browser.addAuthenticationListener(event -> {
            boolean bl = event.doit = false;
        });
        btnCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnCheckButton.getSelection()) {
                    sashForm.setWeights(VISIBLE);
                } else {
                    sashForm.setWeights(HIDDEN);
                }
                container.redraw();
            }
        });
        this.restoreFromMemento(this.savedMemento);
    }

    public void setFocus() {
        this.table.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            if (this.outlinePage == null) {
                Platform.inDevelopmentMode();
                this.outlinePage = new BlogOutlinePage(this);
            }
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection ss;
        BlogEntry post;
        if (event.getSelection() instanceof IStructuredSelection && (post = (BlogEntry)(ss = (IStructuredSelection)event.getSelection()).getFirstElement()) != null) {
            this.browser.setUrl(post.getLink().replaceFirst("http://", "https://"));
            if (!event.getSource().equals(this.tableViewer)) {
                this.tableViewer.setSelection((ISelection)ss, true);
            }
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public void saveState(IMemento memento) {
        if (memento == null) {
            return;
        }
        String id = this.getSite().getId();
        Assert.isNotNull((Object)id);
        IMemento child = memento.createChild(id);
        if (child == null) {
            return;
        }
        child.putString("url", this.browser.getUrl());
    }

    public void restoreState(IMemento memento) {
        this.savedMemento = memento;
    }

    public void restoreFromMemento(IMemento memento) {
        if (memento == null) {
            return;
        }
        String id = this.getSite().getId();
        IMemento child = memento.getChild(id);
        if (child == null) {
            return;
        }
        String url = child.getString("url");
        if (url != null && url.trim().startsWith("http")) {
            this.browser.setUrl(url);
        }
    }
}

