/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.blog.editors;

import com.fold1.eulumdat.blog.BlogActivator;
import com.fold1.eulumdat.blog.reader.BlogEntry;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.swt.SWTResourceManager;

class BlogLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    BlogLabelProvider() {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return SWTResourceManager.getBundleImage(BlogActivator.getDefault().getBundle(), "/icons/internal_browser.png");
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof BlogEntry) {
            BlogEntry post = (BlogEntry)element;
            switch (columnIndex) {
                case 0: {
                    return post.getTitle();
                }
                case 1: {
                    LocalDateTime posted = LocalDateTime.ofEpochSecond(post.getTime() / 1000L, (int)(post.getTime() % 1000L), ZoneOffset.UTC);
                    return String.format("%1$tY-%1$tm-%1$td", posted);
                }
            }
            return post.toString();
        }
        return element.toString();
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }
}

